/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.maven.CamelSpringNamespace;
import org.apache.camel.maven.DocumentationEnricher;
import org.apache.camel.maven.DomFinder;
import org.apache.camel.maven.PackageHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Mojo(name="eip-documentation-enricher", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class EipDocumentationEnricherMojo
extends AbstractMojo {
    @Parameter(required=true)
    File inputCamelSchemaFile;
    @Parameter(required=true)
    File outputCamelSchemaFile;
    @Parameter(defaultValue="${project.build.directory}/../../..//camel-core")
    File camelCoreDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        HashSet<String> injectedTypes = new HashSet<String>();
        File rootDir = new File(this.camelCoreDir, "target/classes/org/apache/camel/model");
        DomFinder domFinder = new DomFinder();
        DocumentationEnricher documentationEnricher = new DocumentationEnricher();
        Map<String, File> jsonFiles = PackageHelper.findJsonFiles(rootDir);
        XPath xPath = this.buildXPath(new CamelSpringNamespace());
        Document document = this.buildNamespaceAwareDocument(this.inputCamelSchemaFile);
        try {
            NodeList elementsAndTypes = domFinder.findElementsAndTypes(document, xPath);
            documentationEnricher.enrichTopLevelElementsDocumentation(document, elementsAndTypes, jsonFiles);
            Map<String, String> typeToNameMap = this.buildTypeToNameMap(elementsAndTypes);
            for (Map.Entry<String, String> entry : typeToNameMap.entrySet()) {
                String elementType = entry.getKey();
                String elementName = entry.getValue();
                if (!this.jsonFileExistsForElement(jsonFiles, elementName)) continue;
                this.injectAttributesDocumentation(domFinder, documentationEnricher, jsonFiles.get(elementName), xPath, document, elementType, injectedTypes);
            }
            this.saveToFile(document, this.outputCamelSchemaFile, this.buildTransformer());
        }
        catch (XPathExpressionException e) {
            throw new MojoExecutionException("Error during documentation enrichment", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during documentation enrichment", (Exception)e);
        }
    }

    private boolean jsonFileExistsForElement(Map<String, File> jsonFiles, String elementName) {
        return jsonFiles.containsKey(elementName);
    }

    private void injectAttributesDocumentation(DomFinder domFinder, DocumentationEnricher documentationEnricher, File jsonFile, XPath xPath, Document document, String type, Set<String> injectedTypes) throws XPathExpressionException, IOException {
        NodeList attributeElements = domFinder.findAttributesElements(document, xPath, type);
        if (attributeElements.getLength() > 0) {
            documentationEnricher.enrichTypeAttributesDocumentation(document, attributeElements, jsonFile);
            injectedTypes.add(type);
            String baseType = domFinder.findBaseType(document, xPath, type);
            baseType = this.truncateTypeNamespace(baseType);
            if (baseType != null && !injectedTypes.contains(baseType)) {
                this.injectAttributesDocumentation(domFinder, documentationEnricher, jsonFile, xPath, document, baseType, injectedTypes);
            }
        }
    }

    private Map<String, String> buildTypeToNameMap(NodeList elementsAndTypes) {
        HashMap<String, String> typeToNameMap = new HashMap<String, String>();
        for (int i = 0; i < elementsAndTypes.getLength(); ++i) {
            Element item = (Element)elementsAndTypes.item(i);
            String name = item.getAttribute("name");
            String type = item.getAttribute("type");
            if (name == null || type == null) continue;
            type = this.truncateTypeNamespace(type);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Putting attributes type:'%s', name:'%s'", name, type));
            }
            typeToNameMap.put(type, name);
        }
        return typeToNameMap;
    }

    private String truncateTypeNamespace(String baseType) {
        return baseType.replaceAll("tns:", "");
    }

    private XPath buildXPath(NamespaceContext namespaceContext) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(namespaceContext);
        return xPath;
    }

    private Transformer buildTransformer() throws MojoExecutionException {
        Transformer transformer;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        catch (TransformerConfigurationException e) {
            throw new MojoExecutionException("Error during building transformer", (Exception)e);
        }
        return transformer;
    }

    public Document buildNamespaceAwareDocument(File xml) throws MojoExecutionException {
        Document result;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            result = builder.parse(xml);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Error during building a document", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Error during building a document", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during building a document", (Exception)e);
        }
        return result;
    }

    private void saveToFile(Document document, File outputFile, Transformer transformer) throws MojoExecutionException {
        try {
            StreamResult result = new StreamResult(new FileOutputStream(outputFile));
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Error during saving to file", (Exception)e);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Error during saving to file", (Exception)e);
        }
    }
}

