/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

public class ElasticsearchConfiguration {
    public static final String PARAM_OPERATION = "operation";
    public static final String OPERATION_INDEX = "INDEX";
    public static final String OPERATION_GET_BY_ID = "GET_BY_ID";
    public static final String OPERATION_DELETE = "DELETE";
    public static final String PARAM_INDEX_ID = "indexId";
    public static final String PARAM_DATA = "data";
    public static final String PARAM_INDEX_NAME = "indexName";
    public static final String PARAM_INDEX_TYPE = "indexType";
    public static final String PROTOCOL = "elasticsearch";
    private static final String LOCAL_NAME = "local";
    private static final String IP = "ip";
    private static final String PORT = "port";
    private static final Integer DEFAULT_PORT = 9300;
    private URI uri;
    private String protocolType;
    private String authority;
    private String clusterName;
    private String indexName;
    private String indexType;
    private boolean local;
    private Boolean data;
    private String operation;
    private String ip;
    private Integer port;

    public ElasticsearchConfiguration(URI uri, Map<String, Object> parameters) throws Exception {
        String protocol = uri.getScheme();
        if (!protocol.equalsIgnoreCase(PROTOCOL)) {
            throw new IllegalArgumentException("unrecognized elasticsearch protocol: " + protocol + " for uri: " + uri);
        }
        this.setUri(uri);
        this.setAuthority(uri.getAuthority());
        if (!this.isValidAuthority()) {
            throw new URISyntaxException(uri.toASCIIString(), "incorrect URI syntax specified for the elasticsearch endpoint.please specify the syntax as \"elasticsearch:[Cluster Name | 'local']?[Query]\"");
        }
        if (LOCAL_NAME.equals(this.getAuthority())) {
            this.setLocal(true);
            this.setClusterName(null);
        } else {
            this.setLocal(false);
            this.setClusterName(this.getAuthority());
        }
        this.data = this.toBoolean(parameters.remove(PARAM_DATA));
        if (this.data == null) {
            this.data = this.local;
        }
        if (this.local && !this.data.booleanValue()) {
            throw new IllegalArgumentException("invalid to use local node without data");
        }
        this.indexName = (String)parameters.remove(PARAM_INDEX_NAME);
        this.indexType = (String)parameters.remove(PARAM_INDEX_TYPE);
        this.operation = (String)parameters.remove(PARAM_OPERATION);
        this.ip = (String)parameters.remove(IP);
        String portParam = (String)parameters.remove(PORT);
        this.port = portParam == null ? DEFAULT_PORT : Integer.valueOf(portParam);
    }

    protected Boolean toBoolean(Object string) {
        if ("true".equals(string)) {
            return true;
        }
        if ("false".equals(string)) {
            return false;
        }
        return null;
    }

    public Node buildNode() {
        NodeBuilder builder = NodeBuilder.nodeBuilder().local(this.isLocal()).data(this.isData());
        if (!this.isLocal() && this.getClusterName() != null) {
            builder.clusterName(this.getClusterName());
        }
        return builder.node();
    }

    private boolean isValidAuthority() throws URISyntaxException {
        return !this.authority.contains(":");
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public void setProtocolType(String protocolType) {
        this.protocolType = protocolType;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean isData() {
        return this.data;
    }

    public void setData(boolean data) {
        this.data = data;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}

