/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.elasticsearch.ElasticsearchComponent;
import org.apache.camel.component.elasticsearch.ElasticsearchConfiguration;
import org.apache.camel.component.elasticsearch.ElasticsearchProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="elasticsearch", title="Elasticsearch", syntax="elasticsearch:clusterName", producerOnly=true, label="monitoring,search")
public class ElasticsearchEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchEndpoint.class);
    private Node node;
    private Client client;
    @UriParam
    private ElasticsearchConfiguration configuration;

    public ElasticsearchEndpoint(String uri, ElasticsearchComponent component, Map<String, Object> parameters) throws Exception {
        super(uri, (Component)component);
        this.configuration = new ElasticsearchConfiguration(new URI(uri), parameters);
    }

    public Producer createProducer() throws Exception {
        return new ElasticsearchProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("Cannot consume to a ElasticsearchEndpoint: " + this.getEndpointUri());
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.configuration.isLocal()) {
            LOG.info("Starting local ElasticSearch server");
        } else {
            LOG.info("Joining ElasticSearch cluster " + this.configuration.getClusterName());
        }
        if (this.configuration.getIp() != null) {
            LOG.info("REMOTE ELASTICSEARCH: {}", (Object)this.configuration.getIp());
            Settings settings = ImmutableSettings.settingsBuilder().classLoader(Settings.class.getClassLoader()).put("cluster.name", this.configuration.getClusterName()).put("client.transport.ignore_cluster_name", false).put("node.client", true).put("client.transport.sniff", true).build();
            TransportClient client = new TransportClient(settings).addTransportAddress((TransportAddress)new InetSocketTransportAddress(this.configuration.getIp(), this.configuration.getPort().intValue()));
            this.client = client;
        } else {
            this.node = this.configuration.buildNode();
            this.client = this.node.client();
        }
    }

    protected void doStop() throws Exception {
        if (this.configuration.isLocal()) {
            LOG.info("Stopping local ElasticSearch server");
        } else {
            LOG.info("Leaving ElasticSearch cluster " + this.configuration.getClusterName());
        }
        this.client.close();
        if (this.node != null) {
            this.node.close();
        }
        super.doStop();
    }

    public Client getClient() {
        return this.client;
    }

    public ElasticsearchConfiguration getConfig() {
        return this.configuration;
    }

    public void setOperation(String operation) {
        this.configuration.setOperation(operation);
    }
}

