/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.cdi;

import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.cdi.Uri;
import org.apache.camel.example.cdi.SomeBean;
import org.apache.camel.model.RouteDefinition;

@ContextName
@Startup
@ApplicationScoped
public class MyRoutes
extends RouteBuilder {
    @Inject
    @Uri(value="file://target/testdata/queue")
    private Endpoint queueEndpoint;
    @Inject
    @Uri(value="file://target/testdata/result?noop=true")
    private Endpoint resultEndpoint;

    public void configure() throws Exception {
        this.from("file:src/data?noop=true").to(this.queueEndpoint);
        ((RouteDefinition)this.from(this.queueEndpoint).to(this.resultEndpoint)).bean((Object)new SomeBean());
    }

    @Named(value="activemq")
    public ActiveMQComponent createActiveMQComponent() {
        ActiveMQComponent answer = new ActiveMQComponent();
        answer.setBrokerURL("vm://localhost.cdi?marshal=false&broker.persistent=false&broker.useJmx=false");
        return answer;
    }

    public Endpoint getResultEndpoint() {
        return this.resultEndpoint;
    }
}

