/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.camel.transport;

import javax.jws.WebService;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.PingMeFault;
import org.apache.hello_world_soap_http.types.FaultDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="CamelPort", serviceName="CamelService", targetNamespace="http://apache.org/hello_world_soap_http", endpointInterface="org.apache.hello_world_soap_http.Greeter")
public class GreeterImpl
implements Greeter {
    private static final Logger LOG = LoggerFactory.getLogger(GreeterImpl.class);
    private String suffix;

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public String greetMe(String me) {
        LOG.info("Executing operation greetMe");
        System.out.println("Executing operation greetMe");
        System.out.println("Message received: " + me + "\n");
        return "Hello " + me + " from " + this.suffix;
    }

    @Override
    public void greetMeOneWay(String me) {
        LOG.info("Executing operation greetMeOneWay");
        System.out.println("Executing operation greetMeOneWay\n");
        System.out.println("Hello there " + me);
    }

    @Override
    public String sayHi() {
        LOG.info("Executing operation sayHi");
        System.out.println("Executing operation sayHi\n");
        return "Bonjour from " + this.suffix;
    }

    @Override
    public void pingMe(String messageIn) throws PingMeFault {
        FaultDetail faultDetail = new FaultDetail();
        faultDetail.setMajor((short)2);
        faultDetail.setMinor((short)1);
        LOG.info("Executing operation pingMe, throwing PingMeFault exception, message = " + messageIn);
        System.out.println("Executing operation pingMe, throwing PingMeFault exception\n");
        throw new PingMeFault("PingMeFault raised by server " + this.suffix, faultDetail);
    }
}

