/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.cxf.httptojms;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.example.cxf.httptojms.Client;
import org.apache.camel.example.cxf.httptojms.JmsBroker;
import org.apache.camel.example.cxf.httptojms.Server;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.test.AvailablePortFinder;
import org.apache.hello_world_soap_http.Greeter;

public final class CamelCxfExample {
    private static final String ROUTER_ADDRESS = "http://localhost:{{routerPort}}/SoapContext/SoapPort";
    private static final String SERVICE_ADDRESS = "jms:jndi:dynamicQueues/test.soap.jmstransport.queue?jndiInitialContextFactory=org.apache.activemq.jndi.ActiveMQInitialContextFactory&jndiConnectionFactoryName=ConnectionFactory&jndiURL=vm://localhost";
    private static final String SERVICE_CLASS = "serviceClass=org.apache.hello_world_soap_http.Greeter";
    private static final String WSDL_LOCATION = "wsdlURL=wsdl/hello_world.wsdl";
    private static final String SERVICE_NAME = "serviceName={http://apache.org/hello_world_soap_http}SOAPService";
    private static final String SOAP_OVER_HTTP_ROUTER = "portName={http://apache.org/hello_world_soap_http}SoapOverHttpRouter";
    private static final String ROUTER_ENDPOINT_URI = "cxf://http://localhost:{{routerPort}}/SoapContext/SoapPort?serviceClass=org.apache.hello_world_soap_http.Greeter&wsdlURL=wsdl/hello_world.wsdl&serviceName={http://apache.org/hello_world_soap_http}SOAPService&portName={http://apache.org/hello_world_soap_http}SoapOverHttpRouter&dataFormat=POJO";

    private CamelCxfExample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.setProperty("routerPort", "9001");
        System.setProperty("servicePort", "9003");
        DefaultCamelContext context = new DefaultCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        context.addComponent("properties", (Component)pc);
        JmsBroker broker = new JmsBroker();
        Server server = new Server();
        try {
            broker.start();
            server.start();
            context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    CxfComponent cxfComponent = new CxfComponent((CamelContext)this.getContext());
                    CxfEndpoint serviceEndpoint = new CxfEndpoint(CamelCxfExample.SERVICE_ADDRESS, cxfComponent);
                    serviceEndpoint.setServiceClass(Greeter.class);
                    this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
                    this.from(CamelCxfExample.ROUTER_ENDPOINT_URI).to((Endpoint)serviceEndpoint);
                }
            });
            String address = ROUTER_ADDRESS.replace("{{routerPort}}", System.getProperty("routerPort"));
            context.start();
            Client client = new Client(address + "?wsdl");
            client.invoke();
            Thread.sleep(1000L);
            context.stop();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            server.stop();
            broker.stop();
            System.exit(0);
        }
    }

    public static class MyRouteBuilder
    extends RouteBuilder {
        public void configure() throws Exception {
            System.setProperty("routerPort", String.valueOf(AvailablePortFinder.getNextAvailable()));
            System.setProperty("servicePort", String.valueOf(AvailablePortFinder.getNextAvailable()));
            CxfComponent cxfComponent = new CxfComponent((CamelContext)this.getContext());
            CxfEndpoint serviceEndpoint = new CxfEndpoint(CamelCxfExample.SERVICE_ADDRESS, cxfComponent);
            serviceEndpoint.setServiceClass(Greeter.class);
            this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
            this.from(CamelCxfExample.ROUTER_ENDPOINT_URI).to((Endpoint)serviceEndpoint);
        }
    }
}

