/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.camel.transport;

import java.net.MalformedURLException;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.PingMeFault;
import org.apache.hello_world_soap_http.types.FaultDetail;

public final class Client {
    private static final QName SERVICE_NAME = new QName("http://apache.org/hello_world_soap_http", "CamelService");
    private static final QName PORT_NAME = new QName("http://apache.org/hello_world_soap_http", "CamelPort");
    private Service service = Service.create((QName)SERVICE_NAME);
    private Greeter port;

    public Client(String address) throws MalformedURLException {
        this.service.addPort(PORT_NAME, "http://schemas.xmlsoap.org/wsdl/soap/http", address);
        System.out.println("Acquiring router port ...");
        this.port = (Greeter)this.service.getPort(PORT_NAME, Greeter.class);
    }

    public Greeter getProxy() {
        return this.port;
    }

    public static void main(String[] args) throws Exception {
        Client client = new Client("http://localhost:9001/GreeterContext/GreeterPort");
        client.invoke();
    }

    public void invoke() throws Exception {
        System.out.println("Invoking sayHi...");
        String resp = this.port.sayHi();
        System.out.println("Server responded with: " + resp);
        System.out.println();
        System.out.println("Invoking greetMe... with Mike");
        resp = this.port.greetMe("Mike");
        System.out.println("Server responded with: " + resp);
        System.out.println();
        System.out.println("Invoking greetMe... with James");
        resp = this.port.greetMe("James");
        System.out.println("Server responded with: " + resp);
        System.out.println();
        System.out.println("Invoking greetMeOneWay...");
        this.port.greetMeOneWay(System.getProperty("user.name"));
        System.out.println("No response from server as method is OneWay");
        System.out.println();
        try {
            System.out.println("Invoking pingMe, expecting exception...");
            this.port.pingMe("hello");
        }
        catch (PingMeFault ex) {
            System.out.println("Expected exception: PingMeFault has occurred: " + ex.getMessage());
            FaultDetail detail = ex.getFaultInfo();
            System.out.println("FaultDetail major:" + detail.getMajor());
            System.out.println("FaultDetail minor:" + detail.getMinor());
        }
    }
}

