/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.cxf.jaxrs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.example.cxf.jaxrs.JAXRSClient;
import org.apache.camel.example.cxf.jaxrs.JAXWSClient;
import org.apache.camel.example.cxf.jaxrs.resources.Book;
import org.apache.camel.example.cxf.jaxrs.resources.BookStore;
import org.apache.camel.example.cxf.jaxrs.resources.BookStoreImpl;
import org.apache.camel.impl.DefaultCamelContext;

public class CamelRouterBuilder
extends RouteBuilder {
    private static final String SOAP_ENDPOINT_URI = "cxf://http://localhost:{{soapEndpointPort}}/soap?serviceClass=org.apache.camel.example.cxf.jaxrs.resources.BookStore";
    private static final String REST_ENDPOINT_URI = "cxfrs://http://localhost:{{restEndpointPort}}/rest?resourceClasses=org.apache.camel.example.cxf.jaxrs.resources.BookStoreImpl";

    public static void main(String[] args) throws Exception {
        System.setProperty("soapEndpointPort", "9006");
        System.setProperty("restEndpointPort", "9002");
        DefaultCamelContext context = new DefaultCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        context.addComponent("properties", (Component)pc);
        context.start();
        context.addRoutes((RoutesBuilder)new CamelRouterBuilder());
        Thread.sleep(1000L);
        JAXWSClient jaxwsClient = new JAXWSClient();
        BookStore bookStore = jaxwsClient.getBookStore();
        bookStore.addBook(new Book("Camel User Guide", 123L));
        Book book = bookStore.getBook(123L);
        System.out.println("Get the book with id 123. " + book);
        try {
            book = bookStore.getBook(124L);
            System.out.println("Get the book with id 124. " + book);
        }
        catch (Exception exception) {
            System.out.println("Expected exception received: " + exception);
        }
        JAXRSClient jaxrsClient = new JAXRSClient();
        bookStore = jaxrsClient.getBookStore();
        bookStore.addBook(new Book("Karaf User Guide", 124L));
        book = bookStore.getBook(124L);
        System.out.println("Get the book with id 124. " + book);
        try {
            book = bookStore.getBook(126L);
            System.out.println("Get the book with id 126. " + book);
        }
        catch (Exception exception) {
            System.out.println("Expected exception received: " + exception);
        }
        Thread.sleep(1000L);
        context.stop();
        System.exit(0);
    }

    public void configure() {
        this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
        this.from(SOAP_ENDPOINT_URI).process((Processor)new MappingProcessor(new BookStoreImpl(false)));
        this.from(REST_ENDPOINT_URI).process((Processor)new MappingProcessor(new BookStoreImpl(true)));
    }

    private static class MappingProcessor
    implements Processor {
        private Class<?> beanClass;
        private Object instance;

        public MappingProcessor(Object obj) {
            this.beanClass = obj.getClass();
            this.instance = obj;
        }

        public void process(Exchange exchange) throws Exception {
            String operationName = (String)exchange.getIn().getHeader("operationName", String.class);
            Method method = this.findMethod(operationName, (Object[])exchange.getIn().getBody(Object[].class));
            try {
                Object response = method.invoke(this.instance, (Object[])exchange.getIn().getBody(Object[].class));
                exchange.getOut().setBody(response);
            }
            catch (InvocationTargetException e) {
                throw (Exception)e.getCause();
            }
        }

        private Method findMethod(String operationName, Object[] parameters) throws SecurityException, NoSuchMethodException {
            return this.beanClass.getMethod(operationName, this.getParameterTypes(parameters));
        }

        private Class<?>[] getParameterTypes(Object[] parameters) {
            if (parameters == null) {
                return new Class[0];
            }
            Class[] answer = new Class[parameters.length];
            int i = 0;
            for (Object object : parameters) {
                answer[i] = object.getClass();
                ++i;
            }
            return answer;
        }
    }
}

