/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.cxf.provider;

import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPBinding;

public final class Client {
    String endpointAddress;

    public Client(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public String invoke() throws Exception {
        Dispatch dispatch;
        QName serviceName = new QName("http://apache.org/hello_world_soap_http", "SOAPService");
        QName portName = new QName("http://apache.org/hello_world_soap_http", "SoapOverHttpRouter");
        Service service = Service.create((QName)serviceName);
        service.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", this.endpointAddress);
        Dispatch bp = dispatch = service.createDispatch(portName, SOAPMessage.class, Service.Mode.MESSAGE);
        MessageFactory factory = ((SOAPBinding)bp.getBinding()).getMessageFactory();
        SOAPMessage request = factory.createMessage();
        SOAPBody body = request.getSOAPBody();
        QName payloadName = new QName("http://apache.org/hello_world_soap_http/types", "greetMe", "ns1");
        SOAPBodyElement payload = body.addBodyElement(payloadName);
        SOAPElement message = payload.addChildElement("requestType");
        message.addTextNode("Hello Camel!!");
        System.out.println("Send out the request: Hello Camel!!");
        SOAPMessage reply = (SOAPMessage)dispatch.invoke((Object)request);
        body = reply.getSOAPBody();
        QName responseName = new QName("http://apache.org/hello_world_soap_http/types", "greetMeResponse");
        SOAPElement bodyElement = (SOAPElement)body.getChildElements(responseName).next();
        String responseMessageText = bodyElement.getTextContent();
        System.out.println("Get the response: " + responseMessageText);
        return responseMessageText;
    }

    public static void main(String[] args) throws Exception {
        Client client = new Client("http://localhost:9000/GreeterContext/SOAPMessageService");
        client.invoke();
    }
}

