/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.etl;

import java.util.List;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.example.etl.CustomerEntity;
import org.apache.camel.example.etl.PersonDocument;
import org.apache.camel.util.CastUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.jpa.JpaTemplate;

@Converter
public class CustomerTransformer {
    private static final transient Log LOG = LogFactory.getLog(CustomerTransformer.class);

    @Converter
    public CustomerEntity toCustomer(PersonDocument doc, Exchange exchange) throws Exception {
        JpaTemplate template = (JpaTemplate)exchange.getIn().getHeader("CamelJpaTemplate", JpaTemplate.class);
        String user = doc.getUser();
        CustomerEntity customer = this.findCustomerByName(template, user);
        customer.setUserName(user);
        customer.setFirstName(doc.getFirstName());
        customer.setSurname(doc.getLastName());
        customer.setCity(doc.getCity());
        LOG.debug((Object)("Created object customer: " + customer));
        return customer;
    }

    protected CustomerEntity findCustomerByName(JpaTemplate template, String user) throws Exception {
        List list = CastUtils.cast((List)template.find("select x from customer x where x.userName = ?1", new Object[]{user}));
        if (list.isEmpty()) {
            CustomerEntity answer = new CustomerEntity();
            answer.setUserName(user);
            return answer;
        }
        return (CustomerEntity)list.get(0);
    }
}

