/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.ftp;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.RouteDefinition;

public class MyFtpClientRouteBuilder
extends RouteBuilder {
    public void configure() throws Exception {
        PropertiesComponent pc = (PropertiesComponent)this.getContext().getComponent("properties", PropertiesComponent.class);
        pc.setLocation("classpath:ftp.properties");
        this.getContext().getShutdownStrategy().setTimeout(10L);
        ((RouteDefinition)((RouteDefinition)this.from("file:target/upload?moveFailed=../error").log("Uploading file ${file:name}")).to("{{ftp.client}}")).log("Uploaded file ${file:name} complete.");
        System.out.println("*********************************************************************************");
        System.out.println("Camel will route files from target/upload directory to the FTP server: " + this.getContext().resolvePropertyPlaceholders("{{ftp.server}}"));
        System.out.println("You can configure the location of the ftp server in the src/main/resources/ftp.properties file.");
        System.out.println("If the file upload fails, then the file is moved to the target/error directory.");
        System.out.println("Use ctrl + c to stop this application.");
        System.out.println("*********************************************************************************");
    }
}

