/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.ftp;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.RouteDefinition;

public class MyFtpServerRouteBuilder
extends RouteBuilder {
    public void configure() throws Exception {
        PropertiesComponent pc = (PropertiesComponent)this.getContext().getComponent("properties", PropertiesComponent.class);
        pc.setLocation("classpath:ftp.properties");
        this.getContext().getShutdownStrategy().setTimeout(10L);
        ((RouteDefinition)this.from("{{ftp.server}}").to("file:target/download")).log("Downloaded file ${file:name} complete.");
        System.out.println("*********************************************************************************");
        System.out.println("Camel will route files from the FTP server: " + this.getContext().resolvePropertyPlaceholders("{{ftp.server}}") + " to the target/download directory.");
        System.out.println("You can configure the location of the ftp server in the src/main/resources/ftp.properties file.");
        System.out.println("Use ctrl + c to stop this application.");
        System.out.println("*********************************************************************************");
    }
}

