/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.gae;

import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.example.gae.ReportData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProcessor
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestProcessor.class);

    public void process(Exchange exchange) throws Exception {
        String requestor;
        UserService userService = UserServiceFactory.getUserService();
        String city = (String)exchange.getIn().removeHeader("city");
        String recipient = requestor = userService.getCurrentUser().getEmail();
        if (exchange.getIn().removeHeader("mailtocurrent") == null) {
            recipient = (String)exchange.getIn().removeHeader("mailto");
        }
        exchange.getIn().setBody((Object)new ReportData(city, recipient, requestor));
        LOGGER.info(requestor + " requested weather data for " + city + ". Report will be sent to " + recipient);
    }
}

