/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.gae;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.example.gae.ReportData;

public class ReportGenerator
implements Processor {
    public void process(Exchange exchange) throws Exception {
        ReportData data = (ReportData)exchange.getIn().getBody(ReportData.class);
        XPathFactory xpfactory = XPathFactory.newInstance();
        XPath xpath = xpfactory.newXPath();
        String city = xpath.evaluate("//forecast_information/city/@data", data.getWeather());
        String cond = xpath.evaluate("//current_conditions/condition/@data", data.getWeather());
        String temp = xpath.evaluate("//current_conditions/temp_c/@data", data.getWeather());
        if (city == null || city.length() == 0) {
            city = data.getCity();
            cond = "<error retrieving current condition>";
            temp = "<error retrieving current temperature>";
        }
        exchange.getIn().setBody((Object)("\n" + "Weather report for:  " + city + "\n" + "Current condition:   " + cond + "\n" + "Current temperature: " + temp + " (Celsius)"));
    }
}

