/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.gae;

import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import java.util.logging.Logger;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.example.gae.ReportData;

public class RequestProcessor
implements Processor {
    private static final Logger LOGGER = Logger.getLogger(RequestProcessor.class.getName());

    public void process(Exchange exchange) throws Exception {
        String requestor;
        UserService userService = UserServiceFactory.getUserService();
        String city = (String)exchange.getIn().removeHeader("city");
        String recipient = requestor = userService.getCurrentUser().getEmail();
        if (exchange.getIn().removeHeader("mailtocurrent") == null) {
            recipient = (String)exchange.getIn().removeHeader("mailto");
        }
        exchange.getIn().setBody((Object)new ReportData(city, recipient, requestor));
        LOGGER.info(requestor + " requested weather data for " + city + ". Report will be sent to " + recipient);
    }
}

