/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.gauth;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;

public class TutorialTokenProcessor
implements Processor {
    private static final int ONE_HOUR = 3600;

    public void process(Exchange exchange) throws Exception {
        String accessToken = (String)exchange.getIn().getHeader("CamelGauthAccessToken", String.class);
        String accessTokenSecret = (String)exchange.getIn().getHeader("CamelGauthAccessTokenSecret", String.class);
        if (accessToken != null) {
            HttpServletResponse servletResponse = (HttpServletResponse)exchange.getIn().getHeader("CamelHttpServletResponse", HttpServletResponse.class);
            Cookie accessTokenCookie = new Cookie("TUTORIAL-ACCESS-TOKEN", accessToken);
            Cookie accessTokenSecretCookie = new Cookie("TUTORIAL-ACCESS-TOKEN-SECRET", accessTokenSecret);
            accessTokenCookie.setPath("/oauth/");
            accessTokenCookie.setMaxAge(3600);
            accessTokenSecretCookie.setPath("/oauth/");
            accessTokenSecretCookie.setMaxAge(3600);
            servletResponse.addCookie(accessTokenCookie);
            servletResponse.addCookie(accessTokenSecretCookie);
        }
        exchange.getOut().setHeader("CamelHttpResponseCode", (Object)302);
        exchange.getOut().setHeader("Location", (Object)"/oauth/calendar");
    }
}

