/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.loanbroker.queue.version;

import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BankResponseAggregationStrategy
implements AggregationStrategy {
    private static final transient Log LOG = LogFactory.getLog(BankResponseAggregationStrategy.class);

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        LOG.debug((Object)("Get the exchange to aggregate, older: " + oldExchange + " newer:" + newExchange));
        Integer old = (Integer)oldExchange.getProperty("aggregated");
        Double oldRate = (Double)oldExchange.getIn().getHeader("rate");
        Double newRate = (Double)newExchange.getIn().getHeader("rate");
        Exchange result = null;
        if (old == null) {
            old = 1;
        }
        result = newRate >= oldRate ? oldExchange : newExchange;
        LOG.debug((Object)("Get the lower rate exchange " + result));
        result.setProperty("aggregated", (Object)(old + 1));
        return result;
    }
}

