/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.loanbroker.queue.version;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.Component;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Routes;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.loanbroker.queue.version.Bank;
import org.apache.camel.loanbroker.queue.version.BankResponseAggregationStrategy;
import org.apache.camel.loanbroker.queue.version.CreditAgency;
import org.apache.camel.loanbroker.queue.version.JmsBroker;
import org.apache.camel.loanbroker.queue.version.Translator;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class LoanBroker
extends RouteBuilder {
    public static void main(String ... args) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        JmsBroker broker = new JmsBroker();
        broker.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        context.addComponent("test-jms", (Component)JmsComponent.jmsComponentAutoAcknowledge((ConnectionFactory)connectionFactory));
        context.addRoutes((Routes)new LoanBroker());
        context.start();
        System.out.println("Server is ready");
        Thread.sleep(300000L);
        context.stop();
        Thread.sleep(1000L);
        broker.stop();
    }

    public void configure() {
        this.from("test-jms:queue:loanRequestQueue").to("test-jms:queue:creditRequestQueue");
        this.from("test-jms:queue:creditRequestQueue").process((Processor)new CreditAgency()).to("test-jms:queue:creditResponseQueue");
        this.from("test-jms:queue:creditResponseQueue").multicast().to(new String[]{"test-jms:queue:bank1", "test-jms:queue:bank2", "test-jms:queue:bank3"});
        this.from("test-jms:queue:bank1").process((Processor)new Bank("bank1")).to("test-jms:queue:bankReplyQueue");
        this.from("test-jms:queue:bank2").process((Processor)new Bank("bank2")).to("test-jms:queue:bankReplyQueue");
        this.from("test-jms:queue:bank3").process((Processor)new Bank("bank3")).to("test-jms:queue:bankReplyQueue");
        this.from("test-jms:queue:bankReplyQueue").aggregator((Expression)this.header("ssn"), (AggregationStrategy)new BankResponseAggregationStrategy()).completedPredicate(this.header("aggregated").isEqualTo((Object)3)).process((Processor)new Translator()).to("test-jms:queue:loanReplyQueue");
    }
}

