/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.loanbroker.webservice.version;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Routes;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.loanbroker.webservice.version.BankResponseAggregationStrategy;
import org.apache.camel.loanbroker.webservice.version.bank.BankServer;
import org.apache.camel.loanbroker.webservice.version.credit.CreditAgencyServer;
import org.apache.camel.loanbroker.webservice.version.credit.CreditAgencyWS;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.cxf.BusFactory;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;

public class LoanBroker
extends RouteBuilder {
    public static void main(String ... args) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        CreditAgencyServer creditAgencyServer = new CreditAgencyServer();
        creditAgencyServer.start();
        BankServer bankServer = new BankServer();
        bankServer.start();
        context.addRoutes((Routes)new LoanBroker());
        context.start();
        Thread.sleep(300000L);
        context.stop();
        Thread.sleep(1000L);
        bankServer.stop();
        creditAgencyServer.stop();
    }

    public void configure() {
        this.from("cxf://http://localhost:9008/loanBroker?serviceClass=org.apache.camel.loanbroker.webservice.version.LoanBrokerWS").process((Processor)new CreditScoreProcessor("http://localhost:9006/creditAgency")).multicast((AggregationStrategy)new BankResponseAggregationStrategy()).to(new String[]{"cxf://http://localhost:9001/bank1?serviceClass=org.apache.camel.loanbroker.webservice.version.bank.BankWS", "cxf://http://localhost:9002/bank2?serviceClass=org.apache.camel.loanbroker.webservice.version.bank.BankWS", "cxf://http://localhost:9003/bank3?serviceClass=org.apache.camel.loanbroker.webservice.version.bank.BankWS"});
        this.from("cxf://http://localhost:9008/parallelLoanBroker?serviceClass=org.apache.camel.loanbroker.webservice.version.LoanBrokerWS").process((Processor)new CreditScoreProcessor("http://localhost:9006/creditAgency")).multicast((AggregationStrategy)new BankResponseAggregationStrategy(), true).to(new String[]{"cxf://http://localhost:9001/bank1?serviceClass=org.apache.camel.loanbroker.webservice.version.bank.BankWS", "cxf://http://localhost:9002/bank2?serviceClass=org.apache.camel.loanbroker.webservice.version.bank.BankWS", "cxf://http://localhost:9003/bank3?serviceClass=org.apache.camel.loanbroker.webservice.version.bank.BankWS"});
    }

    class CreditScoreProcessor
    implements Processor {
        private String creditAgencyAddress;
        private CreditAgencyWS proxy;

        public CreditScoreProcessor(String address) {
            this.creditAgencyAddress = address;
            this.proxy = this.getProxy();
        }

        private CreditAgencyWS getProxy() {
            JaxWsProxyFactoryBean proxyFactory = new JaxWsProxyFactoryBean();
            ClientFactoryBean clientBean = proxyFactory.getClientFactoryBean();
            clientBean.setAddress(this.creditAgencyAddress);
            clientBean.setServiceClass(CreditAgencyWS.class);
            clientBean.setBus(BusFactory.getDefaultBus());
            return (CreditAgencyWS)proxyFactory.create();
        }

        public void process(Exchange exchange) throws Exception {
            Message requestMessage = exchange.getIn();
            List request = (List)requestMessage.getBody();
            String ssn = (String)request.get(0);
            Double amount = (Double)request.get(1);
            Integer loanDuriation = (Integer)request.get(2);
            int historyLength = this.proxy.getCreditHistoryLength(ssn);
            int score = this.proxy.getCreditScore(ssn);
            ArrayList<Object> bankRequest = new ArrayList<Object>();
            bankRequest.add(ssn);
            bankRequest.add(amount);
            bankRequest.add(loanDuriation);
            bankRequest.add(historyLength);
            bankRequest.add(score);
            exchange.getOut().setBody(bankRequest);
            exchange.getOut().setHeader("operationName", (Object)"getQuote");
        }
    }
}

