/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.loanbroker.queue.version;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.Component;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Routes;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.loanbroker.queue.version.Bank;
import org.apache.camel.loanbroker.queue.version.BankResponseAggregationStrategy;
import org.apache.camel.loanbroker.queue.version.CreditAgency;
import org.apache.camel.loanbroker.queue.version.JmsBroker;
import org.apache.camel.loanbroker.queue.version.Translator;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class LoanBroker
extends RouteBuilder {
    public static void main(String ... args) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        JmsBroker broker = new JmsBroker();
        broker.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        context.addComponent("jms", (Component)JmsComponent.jmsComponentAutoAcknowledge((ConnectionFactory)connectionFactory));
        context.addRoutes((Routes)new LoanBroker());
        context.start();
        System.out.println("Server is ready");
        Thread.sleep(300000L);
        context.stop();
        Thread.sleep(1000L);
        broker.stop();
    }

    public void configure() {
        this.from("jms:queue:loanRequestQueue").to("jms:queue:creditRequestQueue");
        this.from("jms:queue:creditRequestQueue").process((Processor)new CreditAgency()).to("jms:queue:creditResponseQueue");
        this.from("jms:queue:creditResponseQueue").multicast().to(new String[]{"jms:queue:bank1", "jms:queue:bank2", "jms:queue:bank3"});
        this.from("jms:queue:bank1").process((Processor)new Bank("bank1")).to("jms:queue:bankReplyQueue");
        this.from("jms:queue:bank2").process((Processor)new Bank("bank2")).to("jms:queue:bankReplyQueue");
        this.from("jms:queue:bank3").process((Processor)new Bank("bank3")).to("jms:queue:bankReplyQueue");
        this.from("jms:queue:bankReplyQueue").aggregator((Expression)this.header("ssn"), (AggregationStrategy)new BankResponseAggregationStrategy()).completedPredicate(this.header("org.apache.camel.Exchange.AggregatedCount").isEqualTo((Object)3)).process((Processor)new Translator()).to("jms:queue:loanReplyQueue");
        this.from("jms:queue2:parallelLoanRequestQueue").process((Processor)new CreditAgency()).multicast((AggregationStrategy)new BankResponseAggregationStrategy().setAggregatingOutMessage(true)).setParallelProcessing(true).to(new String[]{"jms:queue2:bank1", "jms:queue2:bank2", "jms:queue2:bank3"});
        this.from("jms:queue2:bank1").process((Processor)new Bank("bank1"));
        this.from("jms:queue2:bank2").process((Processor)new Bank("bank2"));
        this.from("jms:queue2:bank3").process((Processor)new Bank("bank3"));
    }
}

