/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.loanbroker.webservice.version;

import org.apache.camel.loanbroker.webservice.version.LoanBrokerWS;
import org.apache.cxf.BusFactory;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ClientProxyFactoryBean;

public class Client {
    public LoanBrokerWS getProxy(String address) {
        ClientProxyFactoryBean proxyFactory = new ClientProxyFactoryBean();
        ClientFactoryBean clientBean = proxyFactory.getClientFactoryBean();
        clientBean.setAddress(address);
        clientBean.setServiceClass(LoanBrokerWS.class);
        clientBean.setBus(BusFactory.getDefaultBus());
        return (LoanBrokerWS)proxyFactory.create();
    }

    public static void main(String[] args) {
        Client client = new Client();
        String result = null;
        LoanBrokerWS loanBroker = client.getProxy("http://localhost:9008/loanBroker");
        long startTime = System.currentTimeMillis();
        result = loanBroker.getLoanQuote("Sequential SSN", 1000.54, 10);
        long endTime = System.currentTimeMillis();
        System.out.println("It takes " + (endTime - startTime) + " milliseconds to call the sequential loan broker service");
        System.out.println(result);
        LoanBrokerWS paralleLoanBroker = client.getProxy("http://localhost:9008/parallelLoanBroker");
        startTime = System.currentTimeMillis();
        result = paralleLoanBroker.getLoanQuote("Parallel SSN", 1000.54, 10);
        endTime = System.currentTimeMillis();
        System.out.println("It takes " + (endTime - startTime) + " milliseconds to call the parallel loan broker service");
        System.out.println(result);
    }
}

