/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.loanbroker.webservice.version;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.loanbroker.webservice.version.credit.CreditAgencyWS;
import org.apache.cxf.BusFactory;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;

public class CreditScoreProcessor
implements Processor {
    private String creditAgencyAddress;
    private CreditAgencyWS proxy;

    public CreditScoreProcessor(String address) {
        this.creditAgencyAddress = address;
        this.proxy = this.getProxy();
    }

    private CreditAgencyWS getProxy() {
        JaxWsProxyFactoryBean proxyFactory = new JaxWsProxyFactoryBean();
        ClientFactoryBean clientBean = proxyFactory.getClientFactoryBean();
        clientBean.setAddress(this.creditAgencyAddress);
        clientBean.setServiceClass(CreditAgencyWS.class);
        clientBean.setBus(BusFactory.getDefaultBus());
        return (CreditAgencyWS)proxyFactory.create();
    }

    public void process(Exchange exchange) throws Exception {
        List request = (List)exchange.getIn().getBody(List.class);
        String ssn = (String)request.get(0);
        Double amount = (Double)request.get(1);
        Integer loanDuration = (Integer)request.get(2);
        int historyLength = this.proxy.getCreditHistoryLength(ssn);
        int score = this.proxy.getCreditScore(ssn);
        ArrayList<Object> bankRequest = new ArrayList<Object>();
        bankRequest.add(ssn);
        bankRequest.add(amount);
        bankRequest.add(loanDuration);
        bankRequest.add(historyLength);
        bankRequest.add(score);
        exchange.getOut().setBody(bankRequest);
        exchange.getOut().setHeader("operationName", (Object)"getQuote");
    }
}

