/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.loanbroker.queue.version;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BankResponseAggregationStrategy
implements AggregationStrategy {
    private static final transient Log LOG = LogFactory.getLog(BankResponseAggregationStrategy.class);

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        LOG.debug((Object)("Get the exchange to aggregate, older: " + oldExchange + " newer:" + newExchange));
        if (oldExchange == null) {
            return newExchange;
        }
        Message oldMessage = oldExchange.getIn();
        Message newMessage = newExchange.getIn();
        Double oldRate = (Double)oldMessage.getHeader("rate", Double.class);
        Double newRate = (Double)newMessage.getHeader("rate", Double.class);
        Exchange result = newRate >= oldRate ? oldExchange : newExchange;
        LOG.debug((Object)("Get the lower rate exchange " + result));
        return result;
    }
}

