/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.loanbroker.queue.version;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bank
implements Processor {
    private static final transient Logger LOG = LoggerFactory.getLogger(Bank.class);
    private String bankName;
    private double primeRate;

    public Bank(String name) {
        this.bankName = name;
        this.primeRate = 3.5;
    }

    public void process(Exchange exchange) throws Exception {
        String ssn = (String)exchange.getIn().getHeader("ssn", String.class);
        Integer historyLength = (Integer)exchange.getIn().getHeader("hlength", Integer.class);
        double rate = this.primeRate + (double)(historyLength / 12) / 10.0 + Math.random() * 10.0 / 10.0;
        LOG.info("The bank: " + this.bankName + " for client: " + ssn + " 's rate " + rate);
        exchange.getOut().setHeader("rate", (Object)new Double(rate));
        exchange.getOut().setHeader("bank", (Object)this.bankName);
        exchange.getOut().setHeader("ssn", (Object)ssn);
        exchange.getOut().setBody((Object)"Bank processed the request.");
        try {
            Thread.sleep((int)(Math.random() * 10.0) * 100);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }
}

