/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.loanbroker.queue.version;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankResponseAggregationStrategy
implements AggregationStrategy {
    private static final transient Logger LOG = LoggerFactory.getLogger(BankResponseAggregationStrategy.class);

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        LOG.debug("Get the exchange to aggregate, older: " + oldExchange + " newer:" + newExchange);
        if (oldExchange == null) {
            return newExchange;
        }
        Message oldMessage = oldExchange.getIn();
        Message newMessage = newExchange.getIn();
        Double oldRate = (Double)oldMessage.getHeader("rate", Double.class);
        Double newRate = (Double)newMessage.getHeader("rate", Double.class);
        Exchange result = newRate >= oldRate ? oldExchange : newExchange;
        LOG.debug("Get the lower rate exchange " + result);
        return result;
    }
}

