/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.loanbroker.queue.version;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.impl.DefaultCamelContext;

public class Client
extends RouteBuilder {
    public static void main(String[] args) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:51616");
        context.addComponent("jms", (Component)JmsComponent.jmsComponentAutoAcknowledge((ConnectionFactory)connectionFactory));
        context.addRoutes((RoutesBuilder)new Client());
        ProducerTemplate template = context.createProducerTemplate();
        context.start();
        for (int i = 0; i < 2; ++i) {
            template.sendBodyAndHeader("jms:queue:loanRequestQueue", (Object)"Quote for the lowerst rate of loaning bank", "ssn", (Object)("Client-A" + i));
            Thread.sleep(100L);
        }
        Thread.sleep(2000L);
        Exchange exchange = template.send("jms:queue2:parallelLoanRequestQueue", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setPattern(ExchangePattern.InOut);
                exchange.getIn().setBody((Object)"Quote for the lowerst rate of loaning bank");
                exchange.getIn().setHeader("ssn", (Object)"Client-B");
            }
        });
        String bank = (String)exchange.getOut().getHeader("bank");
        Double rate = (Double)exchange.getOut().getHeader("rate");
        String ssn = (String)exchange.getOut().getHeader("ssn");
        System.out.println("Loan quotion for Client " + ssn + "." + " The lowest rate bank is " + bank + ", the rate is " + rate);
        Thread.sleep(5000L);
        context.stop();
    }

    public void configure() {
        this.from("jms:queue:loanReplyQueue").process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                System.out.println(exchange.getIn().getBody());
            }
        });
    }
}

