/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.loanbroker.webservice.version;

import org.apache.camel.Exchange;
import org.apache.camel.loanbroker.webservice.version.bank.BankQuote;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class BankResponseAggregationStrategy
implements AggregationStrategy {
    public static final String BANK_QUOTE = "bank_quote";

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        BankQuote bankQuote;
        if (oldExchange == null) {
            return newExchange;
        }
        BankQuote oldQuote = (BankQuote)oldExchange.getProperty(BANK_QUOTE, BankQuote.class);
        if (oldQuote == null) {
            oldQuote = (BankQuote)oldExchange.getIn().getBody(BankQuote.class);
        }
        BankQuote newQuote = (BankQuote)newExchange.getIn().getBody(BankQuote.class);
        Exchange result = null;
        if (newQuote.getRate() >= oldQuote.getRate()) {
            result = oldExchange;
            bankQuote = oldQuote;
        } else {
            result = newExchange;
            bankQuote = newQuote;
        }
        result.setProperty(BANK_QUOTE, (Object)bankQuote);
        result.getOut().setBody((Object)("The best rate is " + bankQuote.toString()));
        return result;
    }
}

