/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.loanbroker.queue.version;

import java.io.File;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;

public final class JmsBroker {
    JMSEmbeddedBroker jmsBrokerThread;
    String jmsBrokerUrl = "tcp://localhost:51616";
    String activeMQStorageDir;

    public JmsBroker() {
    }

    public JmsBroker(String url) {
        this.jmsBrokerUrl = url;
    }

    public void start() throws Exception {
        this.jmsBrokerThread = new JMSEmbeddedBroker(this.jmsBrokerUrl);
        this.jmsBrokerThread.startBroker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        JmsBroker jmsBroker = this;
        synchronized (jmsBroker) {
            this.jmsBrokerThread.shutdownBroker = true;
        }
        if (this.jmsBrokerThread != null) {
            this.jmsBrokerThread.join();
        }
        this.jmsBrokerThread = null;
    }

    class JMSEmbeddedBroker
    extends Thread {
        boolean shutdownBroker;
        final String brokerUrl;
        Exception exception;

        public JMSEmbeddedBroker(String url) {
            this.brokerUrl = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startBroker() throws Exception {
            JMSEmbeddedBroker jMSEmbeddedBroker = this;
            synchronized (jMSEmbeddedBroker) {
                super.start();
                try {
                    this.wait();
                    if (this.exception != null) {
                        throw this.exception;
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BrokerService broker = new BrokerService();
                JMSEmbeddedBroker jMSEmbeddedBroker = this;
                synchronized (jMSEmbeddedBroker) {
                    broker.setPersistenceAdapter((PersistenceAdapter)new MemoryPersistenceAdapter());
                    broker.setTmpDataDirectory(new File("./target"));
                    broker.addConnector(this.brokerUrl);
                    broker.start();
                    Thread.sleep(200L);
                    this.notifyAll();
                }
                jMSEmbeddedBroker = this;
                synchronized (jMSEmbeddedBroker) {
                    while (!this.shutdownBroker) {
                        this.wait(1000L);
                    }
                }
                broker.stop();
                broker = null;
            }
            catch (Exception e) {
                this.exception = e;
                e.printStackTrace();
            }
        }
    }
}

