/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.loanbroker.queue.version.bank;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;

public class BankProcessor
implements Processor {
    private final String bankName;
    private final double primeRate;

    public BankProcessor(String name) {
        this.bankName = name;
        this.primeRate = 3.5;
    }

    public void process(Exchange exchange) throws Exception {
        String ssn = (String)exchange.getIn().getHeader("ssn", String.class);
        Integer historyLength = (Integer)exchange.getIn().getHeader("hlength", Integer.class);
        double rate = this.primeRate + (double)(historyLength / 12) / 10.0 + Math.random() * 10.0 / 10.0;
        exchange.getOut().setHeader("bank", (Object)this.bankName);
        exchange.getOut().setHeader("ssn", (Object)ssn);
        exchange.getOut().setHeader("rate", (Object)rate);
    }
}

