/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.management;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.language.XPath;

public class StockService {
    private final List<String> symbols = new ArrayList<String>();
    private Map<String, Integer> stat = new ConcurrentHashMap<String, Integer>();

    public StockService() {
        this.symbols.add("IBM");
        this.symbols.add("APPLE");
        this.symbols.add("ORCL");
    }

    public String transform(@XPath(value="/stock/symbol/text()") String symbol, @XPath(value="/stock/value/text()") String value) {
        Integer hits = this.stat.get(symbol);
        if (hits == null) {
            hits = 1;
        } else {
            Integer n = hits;
            Integer n2 = hits = Integer.valueOf(hits + 1);
        }
        this.stat.put(symbol, hits);
        return symbol + "@" + hits;
    }

    public String getHits() {
        return this.stat.toString();
    }

    public String createRandomStocks() {
        Random ran = new Random();
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xml.append("<stocks>\n");
        for (int i = 0; i < 100; ++i) {
            int winner = ran.nextInt(this.symbols.size());
            String symbol = this.symbols.get(winner);
            int value = ran.nextInt(1000);
            xml.append("<stock>");
            xml.append("<symbol>").append(symbol).append("</symbol>");
            xml.append("<value>").append(value).append("</value>");
            xml.append("</stock>\n");
        }
        xml.append("</stocks>");
        return xml.toString();
    }
}

