/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.reportincident;

import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.example.reportincident.FilenameGenerator;
import org.apache.camel.example.reportincident.InputReportIncident;
import org.apache.camel.example.reportincident.OutputReportIncident;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.language.bean.BeanLanguage;
import org.apache.camel.model.RouteDefinition;

public class ReportIncidentRoutes
extends RouteBuilder {
    private boolean usingServletTransport = true;

    public void setUsingServletTransport(boolean flag) {
        this.usingServletTransport = flag;
    }

    public void configure() throws Exception {
        OutputReportIncident ok = new OutputReportIncident();
        ok.setCode("0");
        String cxfEndpointAddress = "cxf:/incident?bus=#cxf&";
        if (!this.usingServletTransport) {
            cxfEndpointAddress = "cxf://http://localhost:{{port}}/camel-example-reportincident/webservices/incident?";
        }
        String cxfEndpoint = cxfEndpointAddress + "serviceClass=org.apache.camel.example.reportincident.ReportIncidentEndpoint" + "&wsdlURL=etc/report_incident.wsdl";
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(cxfEndpoint).convertBodyTo(InputReportIncident.class)).setHeader("CamelFileName", BeanLanguage.bean(FilenameGenerator.class, (String)"generateFilename"))).to("velocity:etc/MailBody.vm")).to("file://target/subfolder")).log("Wrote ${file:name} and returning OK response")).transform((Expression)this.constant((Object)ok));
        ((RouteDefinition)((RouteDefinition)this.from("file://target/subfolder").setHeader("subject", (Expression)this.constant((Object)"new incident reported"))).log("Sending email to incident@mycompany.com:\n${body}")).to("smtp://someone@localhost?password=secret&to=incident@mycompany.com");
    }

    public static void main(String[] args) throws Exception {
        DefaultCamelContext camel = new DefaultCamelContext();
        ReportIncidentRoutes routes = new ReportIncidentRoutes();
        routes.setUsingServletTransport(false);
        camel.addRoutes((RoutesBuilder)routes);
        camel.start();
    }
}

