/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ProducerTemplate;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class CamelClient {
    private static final int SIZE = 10000;
    private static final int POOL = 100;

    private CamelClient() {
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Notice this client requires that the CamelServer is already running!");
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("camel-client.xml");
        final ProducerTemplate producer = (ProducerTemplate)context.getBean("camelTemplate", ProducerTemplate.class);
        System.out.println("Sending ...");
        final CountDownLatch latch = new CountDownLatch(100);
        ExecutorService executors = Executors.newFixedThreadPool(100);
        for (int i = 0; i < 100; ++i) {
            final Integer idx = i;
            executors.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (int j = 0; j < 100; ++j) {
                            producer.sendBody("jms:queue:inbox", (Object)("Message " + idx * j + j));
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        latch.await(300L, TimeUnit.SECONDS);
        System.out.println("... Send 10000 message to JMS broker");
        executors.shutdownNow();
        context.close();
    }
}

