/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.spring.javaconfig;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.javaconfig.Main;
import org.apache.camel.spring.javaconfig.SingleRouteCamelConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MyRouteConfig
extends SingleRouteCamelConfiguration
implements InitializingBean {
    public static void main(String[] args) throws Exception {
        new Main().run(args);
    }

    protected CamelContext createCamelContext() throws Exception {
        return new SpringCamelContext(this.getApplicationContext());
    }

    protected void setupCamelContext(CamelContext camelContext) throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        connectionFactory.setBrokerURL("vm://localhost.spring.javaconfig?marshal=false&broker.persistent=false&broker.useJmx=false");
        JmsComponent answer = new JmsComponent();
        answer.setConnectionFactory((ConnectionFactory)connectionFactory);
        camelContext.addComponent("jms", (Component)answer);
    }

    @Bean
    public RouteBuilder route() {
        return new RouteBuilder(){

            public void configure() {
                this.from("file:src/data?noop=true").to("jms:test.MyQueue");
                this.from("jms:test.MyQueue").to("file://target/test?noop=true");
                this.from("file://target/test?noop=true").bean((Object)new SomeBean());
            }
        };
    }

    public void afterPropertiesSet() throws Exception {
    }

    public static class SomeBean {
        public void someMethod(String body) {
            System.out.println("Received: " + body);
        }
    }
}

