/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.spring.javaconfig;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.osgi.SpringCamelContextFactory;
import org.apache.camel.spring.javaconfig.Main;
import org.apache.camel.spring.javaconfig.SingleRouteCamelConfiguration;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.osgi.context.BundleContextAware;

@Configuration
public class MyRouteConfig
extends SingleRouteCamelConfiguration
implements InitializingBean,
BundleContextAware {
    private BundleContext bundleContext;

    public static void main(String[] args) throws Exception {
        new Main().run(args);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected CamelContext createCamelContext() throws Exception {
        SpringCamelContextFactory factory = new SpringCamelContextFactory();
        factory.setApplicationContext(this.getApplicationContext());
        factory.setBundleContext(this.getBundleContext());
        return factory.createContext();
    }

    protected void setupCamelContext(CamelContext camelContext) throws Exception {
        JmsComponent answer = new JmsComponent();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        connectionFactory.setBrokerURL("vm://localhost.spring.javaconfig?marshal=false&broker.persistent=false&broker.useJmx=false");
        answer.setConnectionFactory((ConnectionFactory)connectionFactory);
        camelContext.addComponent("jms", (Component)answer);
    }

    @Bean
    public RouteBuilder route() {
        return new RouteBuilder(){

            public void configure() {
                this.from("file:src/data?noop=true").to("jms:test.MyQueue");
                this.from("jms:test.MyQueue").to("file://target/test?noop=true");
                this.from("file://target/test?noop=true").bean((Object)new SomeBean());
            }
        };
    }

    public void afterPropertiesSet() throws Exception {
    }

    public static class SomeBean {
        public void someMethod(String body) {
            System.out.println("Received: " + body);
        }
    }
}

