/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.client;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class CamelClientEndpoint {
    private CamelClientEndpoint() {
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Notice this client requires that the CamelServer is already running!");
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("camel-client.xml");
        CamelContext camel = (CamelContext)context.getBean("camel");
        Endpoint endpoint = camel.getEndpoint("jms:queue:numbers");
        Exchange exchange = endpoint.createExchange(ExchangePattern.InOut);
        exchange.getIn().setBody((Object)11);
        Producer producer = endpoint.createProducer();
        producer.start();
        System.out.println("Invoking the multiply with 11");
        producer.process(exchange);
        int response = (Integer)exchange.getOut().getBody(Integer.class);
        System.out.println("... the result is: " + response);
        producer.stop();
        System.exit(0);
    }
}

