/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.server;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Required;

@Aspect
public class AuditTracker {
    private Endpoint store;

    @Required
    public void setStore(Endpoint store) {
        this.store = store;
    }

    @Before(value="execution(int org.apache.camel.example.server.Multiplier.multiply(int)) && args(originalNumber)")
    public void audit(int originalNumber) throws Exception {
        String msg = "Someone called us with this number " + originalNumber;
        System.out.println(msg);
        Exchange exchange = this.store.createExchange();
        exchange.getIn().setBody((Object)msg);
        this.store.createProducer().process(exchange);
    }
}

