/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.facebook.data;

import facebook4j.Reading;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public final class ReadingBuilder {
    private ReadingBuilder() {
    }

    public static Reading copy(Reading reading, boolean skipSinceUtil) throws NoSuchFieldException, IllegalAccessException {
        Field field = Reading.class.getDeclaredField("parameterMap");
        field.setAccessible(true);
        LinkedHashMap source = (LinkedHashMap)field.get(reading);
        Reading copy = new Reading();
        LinkedHashMap copyMap = new LinkedHashMap();
        copyMap.putAll(source);
        if (skipSinceUtil) {
            copyMap.remove("since");
            copyMap.remove("until");
        }
        field.set(copy, copyMap);
        field.setAccessible(false);
        return copy;
    }

    public static void setProperties(Reading reading, Map<String, Object> readingProperties) {
        Object filter;
        Object with;
        Object locale;
        Object metadata;
        Object since;
        Object until;
        Object offset;
        Object limit;
        String fields = (String)readingProperties.remove("fields");
        if (fields != null) {
            reading.fields(fields.toString().split(","));
        }
        if ((limit = readingProperties.remove("limit")) != null) {
            reading.limit(Integer.parseInt(limit.toString()));
        }
        if ((offset = readingProperties.remove("offset")) != null) {
            reading.offset(Integer.parseInt(offset.toString()));
        }
        if ((until = readingProperties.remove("until")) != null) {
            reading.until(until.toString());
        }
        if ((since = readingProperties.remove("since")) != null) {
            reading.since(since.toString());
        }
        if ((metadata = readingProperties.remove("metadata")) != null && Boolean.parseBoolean(metadata.toString())) {
            reading.metadata();
        }
        if ((locale = readingProperties.remove("locale")) != null) {
            String[] args = locale.toString().split(",");
            switch (args.length) {
                case 1: {
                    reading.locale(new Locale(args[0]));
                    break;
                }
                case 2: {
                    reading.locale(new Locale(args[0], args[1]));
                    break;
                }
                case 3: {
                    reading.locale(new Locale(args[0], args[1], args[2]));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Invalid value for property 'locale' %s, must be of the form [language][,country][,variant]", locale.toString()));
                }
            }
        }
        if ((with = readingProperties.remove("with")) != null && Boolean.parseBoolean(with.toString())) {
            reading.withLocation();
        }
        if ((filter = readingProperties.remove("filter")) != null) {
            reading.filter(filter.toString());
        }
    }

    public static Reading merge(Reading reading, Reading readingUpdate) throws NoSuchFieldException, IllegalAccessException {
        Reading mergedReading = new Reading();
        Field field = Reading.class.getDeclaredField("parameterMap");
        field.setAccessible(true);
        LinkedHashMap readingParameters = (LinkedHashMap)field.get(reading);
        readingParameters.putAll((LinkedHashMap)field.get(readingUpdate));
        field.setAccessible(false);
        ReadingBuilder.setProperties(mergedReading, readingParameters);
        return mergedReading;
    }
}

