/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.fix;

import org.apache.camel.fix.FixEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import quickfix.Application;
import quickfix.DoNotSend;
import quickfix.FieldNotFound;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.Message;
import quickfix.RejectLogon;
import quickfix.SessionID;
import quickfix.UnsupportedMessageType;

public class CamelApplication
implements Application {
    private static final transient Log LOG = LogFactory.getLog(CamelApplication.class);
    private final FixEndpoint endpoint;

    public CamelApplication(FixEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void onCreate(SessionID sessionID) {
        this.endpoint.setSessionID(sessionID);
    }

    public void onLogon(SessionID sessionID) {
        this.endpoint.setSessionID(sessionID);
    }

    public void onLogout(SessionID sessionID) {
    }

    public void toAdmin(Message message, SessionID sessionID) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("toAdmin() session: " + sessionID + " " + message));
        }
    }

    public void fromAdmin(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, RejectLogon {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("fromAdmin() session: " + sessionID + " " + message));
        }
    }

    public void toApp(Message message, SessionID sessionID) throws DoNotSend {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("toApp() session: " + sessionID + " " + message));
        }
        this.endpoint.onMessage(message);
    }

    public void fromApp(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("fromApp() session: " + sessionID + " " + message));
        }
    }
}

