/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.fix;

import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.fix.CamelApplication;
import org.apache.camel.fix.FixProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.LoadBalancerConsumer;
import org.apache.camel.processor.loadbalancer.TopicLoadBalancer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import quickfix.Application;
import quickfix.DefaultMessageFactory;
import quickfix.FileStoreFactory;
import quickfix.LogFactory;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.ScreenLogFactory;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionSettings;

public abstract class FixEndpoint
extends DefaultEndpoint
implements Service {
    private static final transient Log LOG = org.apache.commons.logging.LogFactory.getLog(FixEndpoint.class);
    private final String resourceUri;
    private Session session;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private Resource resource;
    private SessionID sessionID;
    private LoadBalancer loadBalancer;
    private MessageFactory messageFactory = new DefaultMessageFactory();

    public FixEndpoint(String uri, CamelContext camelContext, String resourceUri) {
        super(uri, camelContext);
        this.resourceUri = resourceUri;
    }

    public FixEndpoint(String uri, Component component, String resourceUri) {
        super(uri, component);
        this.resourceUri = resourceUri;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new LoadBalancerConsumer((Endpoint)this, processor, this.getLoadBalancer());
    }

    public Producer createProducer() throws Exception {
        return new FixProducer(this);
    }

    public boolean isSingleton() {
        return true;
    }

    public void onMessage(Message message) {
        Exchange exchange = this.createExchange(message);
        try {
            this.getLoadBalancer().process(exchange);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed " + e + " when processing: " + message), (Throwable)e);
        }
    }

    public Exchange createExchange(Message message) {
        Exchange answer = this.createExchange();
        answer.getIn().setBody((Object)message);
        return answer;
    }

    public void start() throws Exception {
        Resource configResource = this.getResource();
        InputStream inputStream = configResource.getInputStream();
        ObjectHelper.notNull((Object)inputStream, (String)("Could not load " + this.resourceUri));
        SessionSettings settings = new SessionSettings(inputStream);
        CamelApplication application = new CamelApplication(this);
        MessageStoreFactory storeFactory = this.createMessageStoreFactory(settings);
        LogFactory logFactory = this.createLogFactory(settings);
        this.login(settings, application, storeFactory, logFactory);
    }

    public void stop() throws Exception {
        LOG.debug((Object)("Stopping: " + (Object)((Object)this)));
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    public Session getSession() throws Exception {
        if (this.session == null) {
            this.session = this.createSession();
            ObjectHelper.notNull((Object)this.session, (String)"FIX Session");
        }
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public SessionID getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(SessionID sessionID) {
        this.sessionID = sessionID;
    }

    public LoadBalancer getLoadBalancer() {
        if (this.loadBalancer == null) {
            this.loadBalancer = new TopicLoadBalancer();
        }
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public Resource getResource() {
        if (this.resource == null) {
            this.resource = this.getResourceLoader().getResource(this.resourceUri);
            if (this.resource == null) {
                throw new IllegalArgumentException("Could not find resource for URI: " + this.resourceUri + " using: " + this.getResourceLoader());
            }
        }
        return this.resource;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    protected Session createSession() throws Exception {
        return Session.lookupSession((SessionID)this.sessionID);
    }

    protected abstract void login(SessionSettings var1, Application var2, MessageStoreFactory var3, LogFactory var4) throws Exception;

    protected LogFactory createLogFactory(SessionSettings settings) {
        return new ScreenLogFactory(settings);
    }

    protected MessageStoreFactory createMessageStoreFactory(SessionSettings settings) {
        return new FileStoreFactory(settings);
    }
}

