/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.fix;

import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.InvalidTypeException;
import org.apache.camel.fix.FixEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import quickfix.Message;

public class FixProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(FixProducer.class);
    private final FixEndpoint endpoint;

    public FixProducer(FixEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        Message message = this.toQuickMessage(exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sending FIX message : " + message));
        }
        this.endpoint.getSession().send(message);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sent FIX message : " + message));
        }
    }

    protected Message toQuickMessage(Exchange exchange) throws InvalidPayloadException, InvalidTypeException, IOException {
        return (Message)ExchangeHelper.getMandatoryInBody((Exchange)exchange, Message.class);
    }
}

