/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultParserFactory;
import net.sf.flatpack.Parser;
import net.sf.flatpack.ParserFactory;
import net.sf.flatpack.writer.DelimiterWriterFactory;
import net.sf.flatpack.writer.FixedWriterFactory;
import org.apache.camel.Exchange;
import org.apache.camel.component.flatpack.DataSetList;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.JDOMException;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatpackDataFormat
implements DataFormat {
    private static final transient Log LOG = LogFactory.getLog(FlatpackDataFormat.class);
    private ParserFactory parserFactory = DefaultParserFactory.getInstance();
    private char delimiter = (char)44;
    private char textQualifier = (char)34;
    private boolean ignoreFirstRecord = true;
    private Resource definition;
    private boolean fixed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        ObjectHelper.notNull((Object)graph, (String)"The object to marshal must be provided");
        List data = (List)graph;
        if (data.isEmpty()) {
            LOG.warn((Object)"No data to marshal as the list is empty");
            return;
        }
        Map firstRow = (Map)data.get(0);
        net.sf.flatpack.writer.Writer writer = this.createWriter(exchange, firstRow, stream);
        try {
            boolean first = true;
            writer.printHeader();
            for (Map row : data) {
                if (this.ignoreFirstRecord && first) {
                    first = false;
                    continue;
                }
                for (String key : row.keySet()) {
                    writer.addRecordEntry(key, row.get(key));
                }
                writer.nextRecord();
            }
            writer.printFooter();
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        InputStreamReader reader = new InputStreamReader(stream);
        Parser parser = this.createParser(exchange, reader);
        DataSet dataSet = parser.parse();
        return new DataSetList(dataSet);
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isIgnoreFirstRecord() {
        return this.ignoreFirstRecord;
    }

    public void setIgnoreFirstRecord(boolean ignoreFirstRecord) {
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    public char getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(char textQualifier) {
        this.textQualifier = textQualifier;
    }

    public Resource getDefinition() {
        return this.definition;
    }

    public void setDefinition(Resource definition) {
        this.definition = definition;
    }

    public ParserFactory getParserFactory() {
        return this.parserFactory;
    }

    public void setParserFactory(ParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    protected Parser createParser(Exchange exchange, Reader bodyReader) throws IOException {
        if (this.isFixed()) {
            Resource resource = this.getDefinition();
            ObjectHelper.notNull((Object)resource, (String)"resource property");
            return this.getParserFactory().newFixedLengthParser((Reader)new InputStreamReader(resource.getInputStream()), bodyReader);
        }
        Resource resource = this.getDefinition();
        if (resource == null) {
            return this.getParserFactory().newDelimitedParser(bodyReader, this.delimiter, this.textQualifier);
        }
        return this.getParserFactory().newDelimitedParser((Reader)new InputStreamReader(resource.getInputStream()), bodyReader, this.delimiter, this.textQualifier, this.ignoreFirstRecord);
    }

    private net.sf.flatpack.writer.Writer createWriter(Exchange exchange, Map<String, Object> firstRow, OutputStream stream) throws JDOMException, IOException {
        if (this.isFixed()) {
            Resource resource = this.getDefinition();
            ObjectHelper.notNull((Object)resource, (String)"resource property");
            FixedWriterFactory factory = new FixedWriterFactory((Reader)new InputStreamReader(resource.getInputStream()));
            return factory.createWriter((Writer)new OutputStreamWriter(stream));
        }
        Resource resource = this.getDefinition();
        if (resource == null) {
            DelimiterWriterFactory factory = new DelimiterWriterFactory(this.delimiter, this.textQualifier);
            for (String key : firstRow.keySet()) {
                factory.addColumnTitle(key);
            }
            return factory.createWriter((Writer)new OutputStreamWriter(stream));
        }
        DelimiterWriterFactory factory = new DelimiterWriterFactory((Reader)new InputStreamReader(resource.getInputStream()), this.delimiter, this.textQualifier);
        return factory.createWriter((Writer)new OutputStreamWriter(stream));
    }
}

