/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultParserFactory;
import net.sf.flatpack.Parser;
import net.sf.flatpack.ParserFactory;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.flatpack.FlatpackProducer;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.LoadBalancerConsumer;
import org.apache.camel.processor.loadbalancer.RoundRobinLoadBalancer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.springframework.core.io.Resource;

public class FixedLengthEndpoint
extends DefaultPollingEndpoint {
    private final Resource resource;
    private LoadBalancer loadBalancer = new RoundRobinLoadBalancer();
    private ParserFactory parserFactory = DefaultParserFactory.getInstance();
    private boolean splitRows = true;

    public FixedLengthEndpoint(String uri, Resource resource) {
        super(uri);
        this.resource = resource;
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        return new FlatpackProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new LoadBalancerConsumer((Endpoint)this, processor, this.loadBalancer);
    }

    public void processDataSet(DataSet dataSet, int counter) throws Exception {
        Exchange exchange = this.createExchange(dataSet, counter);
        this.loadBalancer.process(exchange);
    }

    public Exchange createExchange(DataSet dataSet, int counter) {
        Exchange answer = this.createExchange();
        Message in = answer.getIn();
        in.setBody((Object)dataSet);
        in.setHeader("camelFlatpackCounter", (Object)counter);
        return answer;
    }

    public Parser createParser(Exchange exchange) throws InvalidPayloadException, IOException {
        Resource resource = this.getResource();
        ObjectHelper.notNull((Object)resource, (String)"resource");
        Reader bodyReader = (Reader)ExchangeHelper.getMandatoryInBody((Exchange)exchange, Reader.class);
        return this.createParser(resource, bodyReader);
    }

    protected Parser createParser(Resource resource, Reader bodyReader) throws IOException {
        return this.getParserFactory().newFixedLengthParser((Reader)new InputStreamReader(resource.getInputStream()), bodyReader);
    }

    public Resource getResource() {
        return this.resource;
    }

    public ParserFactory getParserFactory() {
        return this.parserFactory;
    }

    public void setParserFactory(ParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public boolean isSplitRows() {
        return this.splitRows;
    }

    public void setSplitRows(boolean splitRows) {
        this.splitRows = splitRows;
    }
}

