/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.ResourceBasedComponent;
import org.apache.camel.component.flatpack.DelimitedEndpoint;
import org.apache.camel.component.flatpack.FixedLengthEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatpackComponent
extends ResourceBasedComponent {
    public static final String HEADER_ID = "header";
    public static final String TRAILER_ID = "trailer";

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean fixed = false;
        if (remaining.startsWith("fixed:")) {
            fixed = true;
            remaining = remaining.substring("fixed:".length());
        } else {
            remaining = remaining.startsWith("delim:") ? remaining.substring("delim:".length()) : "";
        }
        Resource resource = null;
        if (fixed) {
            resource = this.resolveMandatoryResource(remaining);
        } else if (ObjectHelper.isNotEmpty((Object)remaining)) {
            resource = this.getResourceLoader().getResource(remaining);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)((Object)((Object)this) + " using flatpack map resource: " + resource));
        }
        FixedLengthEndpoint answer = fixed ? new FixedLengthEndpoint(uri, resource) : new DelimitedEndpoint(uri, resource);
        answer.setCamelContext(this.getCamelContext());
        this.setProperties((Object)answer, parameters);
        return answer;
    }
}

