/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileMessage;

public class RemoteFile<T>
extends GenericFile<T>
implements Cloneable {
    private String hostname;

    public void populateHeaders(GenericFileMessage<T> message) {
        if (message != null) {
            super.populateHeaders(message);
            message.setHeader("CamelFileHost", (Object)this.getHostname());
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public char getFileSeparator() {
        return '/';
    }

    protected boolean isAbsolute(String name) {
        if (name.length() > 0) {
            return name.charAt(0) == '/' || name.charAt(0) == '\\';
        }
        return false;
    }

    protected String normalizePath(String name) {
        return name;
    }

    public void copyFromPopulateAdditional(GenericFile<T> source, GenericFile<T> result) {
        RemoteFile remoteSource = (RemoteFile)source;
        RemoteFile remoteResult = (RemoteFile)result;
        remoteResult.setHostname(remoteSource.getHostname());
    }

    public String toString() {
        return "RemoteFile[" + (this.isAbsolute() ? this.getAbsoluteFilePath() : this.getRelativeFilePath()) + "]";
    }
}

