/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import java.util.List;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

public class SftpConsumer
extends RemoteFileConsumer<ChannelSftp.LsEntry> {
    private String endpointPath;

    public SftpConsumer(RemoteFileEndpoint<ChannelSftp.LsEntry> endpoint, Processor processor, RemoteFileOperations<ChannelSftp.LsEntry> operations) {
        super(endpoint, processor, operations);
        this.endpointPath = endpoint.getConfiguration().getDirectory();
    }

    protected boolean pollDirectory(String fileName, List<GenericFile<ChannelSftp.LsEntry>> fileList) {
        String currentDir = null;
        if (this.isStepwise()) {
            currentDir = this.operations.getCurrentDirectory();
        }
        fileName = FileUtil.stripTrailingSeparator((String)fileName);
        boolean answer = this.doPollDirectory(fileName, null, fileList);
        if (currentDir != null) {
            this.operations.changeCurrentDirectory(currentDir);
        }
        return answer;
    }

    protected boolean pollSubDirectory(String absolutePath, String dirName, List<GenericFile<ChannelSftp.LsEntry>> fileList) {
        boolean answer = this.doPollDirectory(absolutePath, dirName, fileList);
        if (this.isStepwise()) {
            this.operations.changeToParentDirectory();
        }
        return answer;
    }

    protected boolean doPollDirectory(String absolutePath, String dirName, List<GenericFile<ChannelSftp.LsEntry>> fileList) {
        List files;
        String dir;
        if (this.log.isTraceEnabled()) {
            this.log.trace("doPollDirectory from absolutePath: " + absolutePath + ", dirName: " + dirName);
        }
        dirName = FileUtil.stripTrailingSeparator((String)dirName);
        if (this.isStepwise()) {
            dir = ObjectHelper.isNotEmpty((Object)dirName) ? dirName : absolutePath;
            this.operations.changeCurrentDirectory(dir);
        } else {
            dir = absolutePath;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Polling directory: " + dir);
        }
        if ((files = this.isStepwise() ? this.operations.listFiles() : this.operations.listFiles(dir)) == null || files.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("No files found in directory: " + dir);
            }
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Found " + files.size() + " in directory: " + dir);
        }
        for (ChannelSftp.LsEntry file : files) {
            RemoteFile<ChannelSftp.LsEntry> remote;
            if (!this.canPollMoreFiles(fileList)) {
                return false;
            }
            if (file.getAttrs().isDir()) {
                remote = this.asRemoteFile(absolutePath, file);
                if (!this.endpoint.isRecursive() || !this.isValidFile(remote, true)) continue;
                String subDirectory = file.getFilename();
                String path = absolutePath + "/" + subDirectory;
                boolean canPollMore = this.pollSubDirectory(path, subDirectory, fileList);
                if (canPollMore) continue;
                return false;
            }
            remote = this.asRemoteFile(absolutePath, file);
            if (!this.isValidFile(remote, false)) continue;
            if (this.isInProgress(remote)) {
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("Skipping as file is already in progress: " + remote.getFileName());
                continue;
            }
            fileList.add(remote);
        }
        return true;
    }

    private RemoteFile<ChannelSftp.LsEntry> asRemoteFile(String absolutePath, ChannelSftp.LsEntry file) {
        RemoteFile<ChannelSftp.LsEntry> answer = new RemoteFile<ChannelSftp.LsEntry>();
        answer.setEndpointPath(this.endpointPath);
        answer.setFile(file);
        answer.setFileNameOnly(file.getFilename());
        answer.setFileLength(file.getAttrs().getSize());
        answer.setLastModified((long)file.getAttrs().getMTime() * 1000L);
        answer.setHostname(((RemoteFileConfiguration)this.endpoint.getConfiguration()).getHost());
        boolean absolute = FileUtil.hasLeadingSeparator((String)absolutePath);
        answer.setAbsolute(absolute);
        String dir = FileUtil.stripTrailingSeparator((String)absolutePath);
        String absoluteFileName = FileUtil.stripLeadingSeparator((String)(dir + "/" + file.getFilename()));
        if (absolute) {
            absoluteFileName = "/" + absoluteFileName;
        }
        answer.setAbsoluteFilePath(absoluteFileName);
        String relativePath = ObjectHelper.after((String)absoluteFileName, (String)this.endpointPath);
        relativePath = FileUtil.stripLeadingSeparator((String)relativePath);
        answer.setRelativeFilePath(relativePath);
        answer.setFileName(answer.getRelativeFilePath());
        return answer;
    }

    private boolean isStepwise() {
        RemoteFileConfiguration config = (RemoteFileConfiguration)this.endpoint.getConfiguration();
        return config.isStepwise();
    }
}

