/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import org.apache.camel.Exchange;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class RemoteFileProducer<T>
extends GenericFileProducer<T>
implements ServicePoolAware {
    private boolean loggedIn;

    protected RemoteFileProducer(RemoteFileEndpoint<T> endpoint, RemoteFileOperations<T> operations) {
        super(endpoint, operations);
    }

    public String getFileSeparator() {
        return "/";
    }

    public String normalizePath(String name) {
        return name;
    }

    public void process(Exchange exchange) throws Exception {
        Exchange remoteExchange = this.getEndpoint().createExchange(exchange);
        String target = this.createFileName(exchange);
        this.processExchange(remoteExchange, target);
        ExchangeHelper.copyResults((Exchange)exchange, (Exchange)remoteExchange);
    }

    protected RemoteFileOperations getOperations() {
        return (RemoteFileOperations)this.operations;
    }

    public RemoteFileEndpoint<T> getEndpoint() {
        return (RemoteFileEndpoint)super.getEndpoint();
    }

    public void handleFailedWrite(Exchange exchange, Exception exception) throws Exception {
        this.loggedIn = false;
        if (!this.isStopping() && !this.isStopped()) {
            this.log.warn("Writing file failed with: " + exception.getMessage());
            try {
                this.disconnect();
            }
            catch (Exception e) {
                this.log.debug("Ignored exception during disconnect: " + e.getMessage());
            }
            throw exception;
        }
        this.log.debug("Exception occurred during stopping: " + exception.getMessage());
    }

    public void disconnect() throws GenericFileOperationFailedException {
        this.loggedIn = false;
        if (this.getOperations().isConnected()) {
            this.log.debug("Disconnecting from: {}", this.getEndpoint());
            this.getOperations().disconnect();
        }
    }

    public void preWriteCheck() throws Exception {
        boolean noop = false;
        if (this.loggedIn) {
            try {
                noop = this.getOperations().sendNoop();
            }
            catch (Exception e) {
                noop = false;
                this.loggedIn = false;
            }
        }
        this.log.trace("preWriteCheck send noop success: {}", (Object)noop);
        if (!noop) {
            try {
                if (this.getEndpoint().getMaximumReconnectAttempts() > 0) {
                    this.recoverableConnectIfNecessary();
                } else {
                    this.connectIfNecessary();
                }
            }
            catch (Exception e) {
                this.loggedIn = false;
                throw e;
            }
        }
    }

    public void postWriteCheck() {
        try {
            if (this.getEndpoint().isDisconnect()) {
                this.log.trace("postWriteCheck disconnect from: {}", this.getEndpoint());
                this.disconnect();
            }
        }
        catch (GenericFileOperationFailedException e) {
            this.log.warn("Exception occurred during disconnecting from: " + this.getEndpoint() + " " + e.getMessage());
        }
    }

    protected void doStart() throws Exception {
        this.log.debug("Starting");
        super.doStart();
    }

    protected void doStop() throws Exception {
        try {
            this.disconnect();
        }
        catch (Exception e) {
            this.log.debug("Exception occurred during disconnecting from: " + this.getEndpoint() + " " + e.getMessage());
        }
        super.doStop();
    }

    protected void recoverableConnectIfNecessary() throws Exception {
        block5: {
            try {
                this.connectIfNecessary();
            }
            catch (Exception e) {
                this.loggedIn = false;
                InterruptedException ie = (InterruptedException)ObjectHelper.getException(InterruptedException.class, (Throwable)e);
                if (ie != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Interrupted during connect to: " + this.getEndpoint(), (Throwable)ie);
                    }
                    throw ie;
                }
                if (!this.log.isDebugEnabled()) break block5;
                this.log.debug("Could not connect to: " + this.getEndpoint() + ". Will try to recover.", (Throwable)e);
            }
        }
        if (!this.loggedIn) {
            this.log.debug("Trying to recover connection to: {} with a fresh client.", this.getEndpoint());
            this.setOperations(this.getEndpoint().createRemoteFileOperations());
            this.connectIfNecessary();
        }
    }

    protected void connectIfNecessary() throws GenericFileOperationFailedException {
        if (!this.getOperations().isConnected()) {
            this.log.debug("Not already connected/logged in. Connecting to: {}", this.getEndpoint());
            RemoteFileConfiguration config = this.getEndpoint().getConfiguration();
            this.loggedIn = this.getOperations().connect(config);
            if (!this.loggedIn) {
                return;
            }
            this.log.info("Connected and logged in to: " + this.getEndpoint());
        }
    }

    public boolean isSingleton() {
        return false;
    }

    public String toString() {
        return "RemoteFileProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
    }
}

