/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote.strategy;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.StopWatch;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpChangedExclusiveReadLockStrategy
implements GenericFileExclusiveReadLockStrategy<FTPFile> {
    private static final transient Logger LOG = LoggerFactory.getLogger(FtpChangedExclusiveReadLockStrategy.class);
    private long timeout;
    private long checkInterval = 5000L;

    public void prepareOnStartup(GenericFileOperations<FTPFile> tGenericFileOperations, GenericFileEndpoint<FTPFile> tGenericFileEndpoint) throws Exception {
    }

    public boolean acquireExclusiveReadLock(GenericFileOperations<FTPFile> operations, GenericFile<FTPFile> file, Exchange exchange) throws Exception {
        boolean exclusive;
        block7: {
            exclusive = false;
            LOG.trace("Waiting for exclusive read lock to file: " + file);
            try {
                long lastModified = Long.MIN_VALUE;
                long length = Long.MIN_VALUE;
                StopWatch watch = new StopWatch();
                while (!exclusive) {
                    long delta;
                    if (this.timeout > 0L && (delta = watch.taken()) > this.timeout) {
                        LOG.warn("Cannot acquire read lock within " + this.timeout + " millis. Will skip the file: " + file);
                        return false;
                    }
                    long newLastModified = 0L;
                    long newLength = 0L;
                    List files = operations.listFiles(file.getParent());
                    for (FTPFile f : files) {
                        if (!f.getName().equals(file.getFileName())) continue;
                        newLastModified = f.getTimestamp().getTimeInMillis();
                        newLength = f.getSize();
                    }
                    LOG.trace("Previous last modified: " + lastModified + ", new last modified: " + newLastModified);
                    LOG.trace("Previous length: " + length + ", new length: " + newLength);
                    if (newLastModified == lastModified && newLength == length && length != 0L) {
                        LOG.trace("Read lock acquired.");
                        exclusive = true;
                        continue;
                    }
                    lastModified = newLastModified;
                    length = newLength;
                    boolean interrupted = this.sleep();
                    if (!interrupted) continue;
                    return false;
                }
            }
            catch (Exception e) {
                if (this.timeout == 0L) {
                    throw e;
                }
                LOG.debug("Cannot acquire read lock. Will try again.", (Throwable)e);
                boolean interrupted = this.sleep();
                if (!interrupted) break block7;
                return false;
            }
        }
        return exclusive;
    }

    private boolean sleep() {
        LOG.trace("Exclusive read lock not granted. Sleeping for " + this.checkInterval + " millis.");
        try {
            Thread.sleep(this.checkInterval);
            return false;
        }
        catch (InterruptedException e) {
            LOG.debug("Sleep interrupted while waiting for exclusive read lock, so breaking out");
            return true;
        }
    }

    public void releaseExclusiveReadLock(GenericFileOperations<FTPFile> tGenericFileOperations, GenericFile<FTPFile> tGenericFile, Exchange exchange) throws Exception {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }
}

