/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFileConfiguration;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.remote.FtpConfiguration;
import org.apache.camel.component.file.remote.FtpConsumer;
import org.apache.camel.component.file.remote.FtpOperations;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.RemoteFileProducer;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;

public class FtpEndpoint<T extends FTPFile>
extends RemoteFileEndpoint<FTPFile> {
    protected FTPClient ftpClient;
    protected FTPClientConfig ftpClientConfig;
    protected Map<String, Object> ftpClientParameters;
    protected Map<String, Object> ftpClientConfigParameters;
    protected int soTimeout;
    protected int dataTimeout;

    public FtpEndpoint() {
    }

    public FtpEndpoint(String uri, RemoteFileComponent<FTPFile> component, RemoteFileConfiguration configuration) {
        super(uri, component, configuration);
    }

    public String getScheme() {
        return "ftp";
    }

    @Override
    protected RemoteFileConsumer<FTPFile> buildConsumer(Processor processor) {
        try {
            return new FtpConsumer(this, processor, this.createRemoteFileOperations());
        }
        catch (Exception e) {
            throw new FailedToCreateConsumerException((Endpoint)this, (Throwable)e);
        }
    }

    @Override
    protected GenericFileProducer<FTPFile> buildProducer() {
        try {
            return new RemoteFileProducer<FTPFile>(this, this.createRemoteFileOperations());
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException((Endpoint)this, (Throwable)e);
        }
    }

    @Override
    public RemoteFileOperations<FTPFile> createRemoteFileOperations() throws Exception {
        FTPClient client = this.ftpClient;
        if (client == null) {
            client = this.createFtpClient();
        }
        if (this.getConfiguration().getConnectTimeout() > -1) {
            client.setConnectTimeout(this.getConfiguration().getConnectTimeout());
        }
        if (this.getConfiguration().getSoTimeout() > -1) {
            this.soTimeout = this.getConfiguration().getSoTimeout();
        }
        this.dataTimeout = this.getConfiguration().getTimeout();
        if (this.ftpClientParameters != null) {
            Object timeout = this.ftpClientParameters.remove("soTimeout");
            if (timeout != null) {
                this.soTimeout = (Integer)this.getCamelContext().getTypeConverter().convertTo(Integer.TYPE, timeout);
            }
            if ((timeout = this.ftpClientParameters.remove("dataTimeout")) != null) {
                this.dataTimeout = (Integer)this.getCamelContext().getTypeConverter().convertTo(Integer.TYPE, (Object)this.dataTimeout);
            }
            IntrospectionSupport.setProperties((Object)client, this.ftpClientParameters);
        }
        if (this.ftpClientConfigParameters != null) {
            if (this.ftpClientConfig == null) {
                this.ftpClientConfig = new FTPClientConfig();
            }
            IntrospectionSupport.setProperties((Object)this.ftpClientConfig, this.ftpClientConfigParameters);
        }
        if (this.dataTimeout > 0) {
            client.setDataTimeout(this.dataTimeout);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created FTPClient [connectTimeout: {}, soTimeout: {}, dataTimeout: {}]: {}", new Object[]{client.getConnectTimeout(), this.getSoTimeout(), this.dataTimeout, client});
        }
        FtpOperations operations = new FtpOperations(client, this.getFtpClientConfig());
        operations.setEndpoint(this);
        return operations;
    }

    protected FTPClient createFtpClient() throws Exception {
        return new FTPClient();
    }

    @Override
    public FtpConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new FtpConfiguration();
        }
        return (FtpConfiguration)this.configuration;
    }

    public void setConfiguration(GenericFileConfiguration configuration) {
        this.setConfiguration((FtpConfiguration)configuration);
    }

    public void setConfiguration(FtpConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("FtpConfiguration expected");
        }
        this.configuration = configuration;
    }

    public FTPClient getFtpClient() {
        return this.ftpClient;
    }

    public void setFtpClient(FTPClient ftpClient) {
        this.ftpClient = ftpClient;
    }

    public FTPClientConfig getFtpClientConfig() {
        return this.ftpClientConfig;
    }

    public void setFtpClientConfig(FTPClientConfig ftpClientConfig) {
        this.ftpClientConfig = ftpClientConfig;
    }

    void setFtpClientParameters(Map<String, Object> ftpClientParameters) {
        this.ftpClientParameters = ftpClientParameters;
    }

    void setFtpClientConfigParameters(Map<String, Object> ftpClientConfigParameters) {
        this.ftpClientConfigParameters = ftpClientConfigParameters;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }
}

