/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.auth;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.gae.auth.GAuthAuthorizeBinding;
import org.apache.camel.component.gae.auth.GAuthEndpoint;
import org.apache.camel.component.gae.auth.GAuthKeyLoader;
import org.apache.camel.component.gae.auth.GAuthService;
import org.apache.camel.component.gae.auth.GAuthServiceImpl;
import org.apache.camel.component.gae.auth.GAuthUpgradeBinding;
import org.apache.camel.component.gae.bind.OutboundBinding;
import org.apache.camel.impl.DefaultComponent;

public class GAuthComponent
extends DefaultComponent {
    private String consumerKey;
    private String consumerSecret;
    private GAuthKeyLoader keyLoader;

    public GAuthComponent() {
        this(null);
    }

    public GAuthComponent(CamelContext context) {
        super(context);
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public GAuthKeyLoader getKeyLoader() {
        return this.keyLoader;
    }

    public void setKeyLoader(GAuthKeyLoader keyLoader) {
        this.keyLoader = keyLoader;
    }

    public GAuthEndpoint createEndpoint(String uri) throws Exception {
        return (GAuthEndpoint)super.createEndpoint(uri);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        GAuthEndpoint endpoint = new GAuthEndpoint(uri, (Component)this, remaining);
        OutboundBinding authorizeBinding = (OutboundBinding)this.resolveAndRemoveReferenceParameter(parameters, "authorizeBindingRef", GAuthAuthorizeBinding.class, new GAuthAuthorizeBinding());
        OutboundBinding upgradeBinding = (OutboundBinding)this.resolveAndRemoveReferenceParameter(parameters, "upgradeBindingRef", GAuthUpgradeBinding.class, new GAuthUpgradeBinding());
        GAuthService service = (GAuthService)this.resolveAndRemoveReferenceParameter(parameters, "serviceRef", GAuthService.class, new GAuthServiceImpl(endpoint));
        GAuthKeyLoader keyLoader = (GAuthKeyLoader)this.resolveAndRemoveReferenceParameter(parameters, "keyLoaderRef", GAuthKeyLoader.class);
        endpoint.setAuthorizeBinding(authorizeBinding);
        endpoint.setUpgradeBinding(upgradeBinding);
        endpoint.setService(service);
        if (keyLoader != null) {
            keyLoader.setCamelContext(this.getCamelContext());
        }
        endpoint.setKeyLoader(keyLoader);
        return endpoint;
    }
}

