/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.auth;

import com.google.gdata.client.authn.oauth.GoogleOAuthParameters;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.component.gae.auth.GAuthEndpoint;
import org.apache.camel.component.gae.auth.GAuthException;
import org.apache.camel.component.gae.auth.GAuthTokenSecret;
import org.apache.camel.component.gae.bind.OutboundBinding;

public class GAuthUpgradeBinding
implements OutboundBinding<GAuthEndpoint, GoogleOAuthParameters, GoogleOAuthParameters> {
    public static final String GAUTH_ACCESS_TOKEN = "CamelGauthAccessToken";
    public static final String GAUTH_ACCESS_TOKEN_SECRET = "CamelGauthAccessTokenSecret";
    private static final String EMPTY_TOKEN = "";

    @Override
    public GoogleOAuthParameters writeRequest(GAuthEndpoint endpoint, Exchange exchange, GoogleOAuthParameters request) throws Exception {
        request = new GoogleOAuthParameters();
        request.setOAuthConsumerKey(endpoint.getConsumerKey());
        request.setOAuthConsumerSecret(endpoint.getConsumerSecret());
        request.setOAuthToken((String)exchange.getIn().getHeader("oauth_token", String.class));
        request.setOAuthVerifier((String)exchange.getIn().getHeader("oauth_verifier", String.class));
        if (endpoint.getComponent().getKeyLoader() == null) {
            String cookie = (String)exchange.getIn().getHeader("Cookie", String.class);
            GAuthTokenSecret tokenSecret = GAuthTokenSecret.fromCookie(cookie);
            if (tokenSecret == null) {
                throw new GAuthException("gauth-token-secret cookie doesn't exist");
            }
            request.setOAuthTokenSecret(tokenSecret.getValue());
        }
        return request;
    }

    @Override
    public Exchange readResponse(GAuthEndpoint endpoint, Exchange exchange, GoogleOAuthParameters response) throws IOException {
        exchange.getOut().setHeaders(exchange.getIn().getHeaders());
        exchange.getOut().setHeader(GAUTH_ACCESS_TOKEN, (Object)GAuthUpgradeBinding.canonicalizeToken(response.getOAuthToken()));
        exchange.getOut().setHeader(GAUTH_ACCESS_TOKEN_SECRET, (Object)GAuthUpgradeBinding.canonicalizeToken(response.getOAuthTokenSecret()));
        return exchange;
    }

    private static String canonicalizeToken(String token) {
        if (token == null) {
            return null;
        }
        if (EMPTY_TOKEN.equals(token)) {
            return null;
        }
        return token;
    }
}

